#ifndef CUFFTDX_FFT_27_FP32_INV_PTX_HPP
#define CUFFTDX_FFT_27_FP32_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<323, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<796>;
.reg .b64 rd<5>;
add.f32 f109, %72, %90;
add.f32 f110, %54, f109;
mul.f32 f113, f109, 0f3F000000;
sub.f32 f114, %54, f113;
add.f32 f789, %73, %91;
sub.f32 f115, %73, %91;
mul.f32 f116, f115, 0fBF5DB3D7;
add.f32 f117, f116, f114;
sub.f32 f118, f114, f116;
add.f32 f788, %55, f789;
mul.f32 f119, f789, 0f3F000000;
sub.f32 f120, %55, f119;
sub.f32 f121, %72, %90;
mul.f32 f122, f121, 0fBF5DB3D7;
sub.f32 f123, f120, f122;
add.f32 f124, f122, f120;
add.f32 f125, %78, %96;
add.f32 f126, %60, f125;
mul.f32 f129, f125, 0f3F000000;
sub.f32 f130, %60, f129;
add.f32 f787, %79, %97;
sub.f32 f131, %79, %97;
mul.f32 f132, f131, 0fBF5DB3D7;
add.f32 f133, f132, f130;
sub.f32 f134, f130, f132;
add.f32 f786, %61, f787;
mul.f32 f135, f787, 0f3F000000;
sub.f32 f136, %61, f135;
sub.f32 f137, %78, %96;
mul.f32 f138, f137, 0fBF5DB3D7;
sub.f32 f139, f136, f138;
add.f32 f140, f138, f136;
add.f32 f141, %84, %102;
add.f32 f142, %66, f141;
mul.f32 f145, f141, 0f3F000000;
sub.f32 f146, %66, f145;
add.f32 f785, %85, %103;
sub.f32 f147, %85, %103;
mul.f32 f148, f147, 0fBF5DB3D7;
add.f32 f149, f148, f146;
sub.f32 f150, f146, f148;
add.f32 f784, %67, f785;
mul.f32 f151, f785, 0f3F000000;
sub.f32 f152, %67, f151;
sub.f32 f153, %84, %102;
mul.f32 f154, f153, 0fBF5DB3D7;
sub.f32 f155, f152, f154;
add.f32 f156, f154, f152;
mul.f32 f158, f139, 0f3F248DBB;
mul.f32 f783, f133, 0f3F441B7D;
sub.f32 f159, f783, f158;
mul.f32 f160, f139, 0f3F441B7D;
fma.rn.f32 f161, f133, 0f3F248DBB, f160;
mul.f32 f163, f155, 0f3F7C1C5C;
mul.f32 f782, f149, 0f3E31D0D4;
sub.f32 f164, f782, f163;
mul.f32 f165, f155, 0f3E31D0D4;
fma.rn.f32 f166, f149, 0f3F7C1C5C, f165;
mul.f32 f168, f140, 0f3F7C1C5C;
mul.f32 f781, f134, 0f3E31D0D4;
sub.f32 f169, f781, f168;
mul.f32 f170, f140, 0f3E31D0D4;
fma.rn.f32 f171, f134, 0f3F7C1C5C, f170;
mul.f32 f173, f156, 0f3EAF1D44;
mul.f32 f780, f150, 0fBF708FB2;
sub.f32 f174, f780, f173;
mul.f32 f175, f156, 0fBF708FB2;
fma.rn.f32 f176, f150, 0f3EAF1D44, f175;
add.f32 f177, f126, f142;
add.f32 f178, f110, f177;
mul.f32 f181, f177, 0f3F000000;
sub.f32 f182, f110, f181;
add.f32 f779, f786, f784;
sub.f32 f183, f786, f784;
mul.f32 f184, f183, 0fBF5DB3D7;
add.f32 f185, f184, f182;
sub.f32 f186, f182, f184;
add.f32 f778, f788, f779;
mul.f32 f187, f779, 0f3F000000;
sub.f32 f188, f788, f187;
sub.f32 f189, f126, f142;
mul.f32 f190, f189, 0fBF5DB3D7;
sub.f32 f191, f188, f190;
add.f32 f192, f190, f188;
add.f32 f193, f159, f164;
add.f32 f194, f117, f193;
mul.f32 f197, f193, 0f3F000000;
sub.f32 f198, f117, f197;
add.f32 f777, f161, f166;
sub.f32 f199, f161, f166;
mul.f32 f200, f199, 0fBF5DB3D7;
add.f32 f201, f200, f198;
sub.f32 f202, f198, f200;
add.f32 f776, f123, f777;
mul.f32 f203, f777, 0f3F000000;
sub.f32 f204, f123, f203;
sub.f32 f205, f159, f164;
mul.f32 f206, f205, 0fBF5DB3D7;
sub.f32 f207, f204, f206;
add.f32 f208, f206, f204;
add.f32 f209, f169, f174;
add.f32 f210, f118, f209;
mul.f32 f213, f209, 0f3F000000;
sub.f32 f214, f118, f213;
add.f32 f775, f171, f176;
sub.f32 f215, f171, f176;
mul.f32 f216, f215, 0fBF5DB3D7;
add.f32 f217, f216, f214;
sub.f32 f218, f214, f216;
add.f32 f774, f124, f775;
mul.f32 f219, f775, 0f3F000000;
sub.f32 f220, f124, f219;
sub.f32 f221, f169, f174;
mul.f32 f222, f221, 0fBF5DB3D7;
sub.f32 f223, f220, f222;
add.f32 f224, f222, f220;
add.f32 f225, %74, %92;
add.f32 f226, %56, f225;
mul.f32 f229, f225, 0f3F000000;
sub.f32 f230, %56, f229;
add.f32 f771, %109, %108;
sub.f32 f231, %109, %108;
mul.f32 f232, f231, 0fBF5DB3D7;
add.f32 f233, f232, f230;
sub.f32 f234, f230, f232;
add.f32 f769, %110, f771;
mul.f32 f235, f771, 0f3F000000;
sub.f32 f236, %110, f235;
sub.f32 f237, %74, %92;
mul.f32 f238, f237, 0fBF5DB3D7;
sub.f32 f239, f236, f238;
add.f32 f240, f238, f236;
add.f32 f241, %80, %98;
add.f32 f242, %62, f241;
mul.f32 f245, f241, 0f3F000000;
sub.f32 f246, %62, f245;
add.f32 f766, %111, %112;
sub.f32 f247, %111, %112;
mul.f32 f248, f247, 0fBF5DB3D7;
add.f32 f249, f248, f246;
sub.f32 f250, f246, f248;
add.f32 f764, %113, f766;
mul.f32 f251, f766, 0f3F000000;
sub.f32 f252, %113, f251;
sub.f32 f253, %80, %98;
mul.f32 f254, f253, 0fBF5DB3D7;
sub.f32 f255, f252, f254;
add.f32 f256, f254, f252;
add.f32 f257, %86, %104;
add.f32 f258, %68, f257;
mul.f32 f261, f257, 0f3F000000;
sub.f32 f262, %68, f261;
add.f32 f761, %115, %114;
sub.f32 f263, %115, %114;
mul.f32 f264, f263, 0fBF5DB3D7;
add.f32 f265, f264, f262;
sub.f32 f266, f262, f264;
add.f32 f759, %116, f761;
mul.f32 f267, f761, 0f3F000000;
sub.f32 f268, %116, f267;
sub.f32 f269, %86, %104;
mul.f32 f270, f269, 0fBF5DB3D7;
sub.f32 f271, f268, f270;
add.f32 f272, f270, f268;
mul.f32 f274, f255, 0f3F248DBB;
mul.f32 f758, f249, 0f3F441B7D;
sub.f32 f275, f758, f274;
mul.f32 f276, f255, 0f3F441B7D;
fma.rn.f32 f277, f249, 0f3F248DBB, f276;
mul.f32 f279, f271, 0f3F7C1C5C;
mul.f32 f757, f265, 0f3E31D0D4;
sub.f32 f280, f757, f279;
mul.f32 f281, f271, 0f3E31D0D4;
fma.rn.f32 f282, f265, 0f3F7C1C5C, f281;
mul.f32 f284, f256, 0f3F7C1C5C;
mul.f32 f756, f250, 0f3E31D0D4;
sub.f32 f285, f756, f284;
mul.f32 f286, f256, 0f3E31D0D4;
fma.rn.f32 f287, f250, 0f3F7C1C5C, f286;
mul.f32 f289, f272, 0f3EAF1D44;
mul.f32 f755, f266, 0fBF708FB2;
sub.f32 f290, f755, f289;
mul.f32 f291, f272, 0fBF708FB2;
fma.rn.f32 f292, f266, 0f3EAF1D44, f291;
add.f32 f293, f242, f258;
add.f32 f294, f226, f293;
mul.f32 f297, f293, 0f3F000000;
sub.f32 f298, f226, f297;
add.f32 f754, f764, f759;
sub.f32 f299, f764, f759;
mul.f32 f300, f299, 0fBF5DB3D7;
add.f32 f301, f300, f298;
sub.f32 f302, f298, f300;
add.f32 f753, f769, f754;
mul.f32 f303, f754, 0f3F000000;
sub.f32 f304, f769, f303;
sub.f32 f305, f242, f258;
mul.f32 f306, f305, 0fBF5DB3D7;
sub.f32 f307, f304, f306;
add.f32 f308, f306, f304;
add.f32 f309, f275, f280;
add.f32 f310, f233, f309;
mul.f32 f313, f309, 0f3F000000;
sub.f32 f314, f233, f313;
add.f32 f752, f277, f282;
sub.f32 f315, f277, f282;
mul.f32 f316, f315, 0fBF5DB3D7;
add.f32 f317, f316, f314;
sub.f32 f318, f314, f316;
add.f32 f751, f239, f752;
mul.f32 f319, f752, 0f3F000000;
sub.f32 f320, f239, f319;
sub.f32 f321, f275, f280;
mul.f32 f322, f321, 0fBF5DB3D7;
sub.f32 f323, f320, f322;
add.f32 f324, f322, f320;
add.f32 f325, f285, f290;
add.f32 f326, f234, f325;
mul.f32 f329, f325, 0f3F000000;
sub.f32 f330, f234, f329;
add.f32 f750, f287, f292;
sub.f32 f331, f287, f292;
mul.f32 f332, f331, 0fBF5DB3D7;
add.f32 f333, f332, f330;
sub.f32 f334, f330, f332;
add.f32 f749, f240, f750;
mul.f32 f335, f750, 0f3F000000;
sub.f32 f336, f240, f335;
sub.f32 f337, f285, f290;
mul.f32 f338, f337, 0fBF5DB3D7;
sub.f32 f339, f336, f338;
add.f32 f340, f338, f336;
add.f32 f341, %76, %94;
add.f32 f342, %58, f341;
mul.f32 f345, f341, 0f3F000000;
sub.f32 f346, %58, f345;
add.f32 f746, %118, %117;
sub.f32 f347, %118, %117;
mul.f32 f348, f347, 0fBF5DB3D7;
add.f32 f349, f348, f346;
sub.f32 f350, f346, f348;
add.f32 f744, %119, f746;
mul.f32 f351, f746, 0f3F000000;
sub.f32 f352, %119, f351;
sub.f32 f353, %76, %94;
mul.f32 f354, f353, 0fBF5DB3D7;
sub.f32 f355, f352, f354;
add.f32 f356, f354, f352;
add.f32 f357, %82, %100;
add.f32 f358, %64, f357;
mul.f32 f361, f357, 0f3F000000;
sub.f32 f362, %64, f361;
add.f32 f741, %121, %120;
sub.f32 f363, %121, %120;
mul.f32 f364, f363, 0fBF5DB3D7;
add.f32 f365, f364, f362;
sub.f32 f366, f362, f364;
add.f32 f739, %122, f741;
mul.f32 f367, f741, 0f3F000000;
sub.f32 f368, %122, f367;
sub.f32 f369, %82, %100;
mul.f32 f370, f369, 0fBF5DB3D7;
sub.f32 f371, f368, f370;
add.f32 f372, f370, f368;
add.f32 f373, %88, %106;
add.f32 f374, %70, f373;
mul.f32 f377, f373, 0f3F000000;
sub.f32 f378, %70, f377;
add.f32 f737, %123, %107;
sub.f32 f379, %123, %107;
mul.f32 f380, f379, 0fBF5DB3D7;
add.f32 f381, f380, f378;
sub.f32 f382, f378, f380;
add.f32 f735, %124, f737;
mul.f32 f383, f737, 0f3F000000;
sub.f32 f384, %124, f383;
sub.f32 f385, %88, %106;
mul.f32 f386, f385, 0fBF5DB3D7;
sub.f32 f387, f384, f386;
add.f32 f388, f386, f384;
mul.f32 f390, f371, 0f3F248DBB;
mul.f32 f734, f365, 0f3F441B7D;
sub.f32 f391, f734, f390;
mul.f32 f392, f371, 0f3F441B7D;
fma.rn.f32 f393, f365, 0f3F248DBB, f392;
mul.f32 f395, f387, 0f3F7C1C5C;
mul.f32 f733, f381, 0f3E31D0D4;
sub.f32 f396, f733, f395;
mul.f32 f397, f387, 0f3E31D0D4;
fma.rn.f32 f398, f381, 0f3F7C1C5C, f397;
mul.f32 f400, f372, 0f3F7C1C5C;
mul.f32 f732, f366, 0f3E31D0D4;
sub.f32 f401, f732, f400;
mul.f32 f402, f372, 0f3E31D0D4;
fma.rn.f32 f403, f366, 0f3F7C1C5C, f402;
mul.f32 f405, f388, 0f3EAF1D44;
mul.f32 f731, f382, 0fBF708FB2;
sub.f32 f406, f731, f405;
mul.f32 f407, f388, 0fBF708FB2;
fma.rn.f32 f408, f382, 0f3EAF1D44, f407;
add.f32 f409, f358, f374;
add.f32 f410, f342, f409;
mul.f32 f413, f409, 0f3F000000;
sub.f32 f414, f342, f413;
add.f32 f730, f739, f735;
sub.f32 f415, f739, f735;
mul.f32 f416, f415, 0fBF5DB3D7;
add.f32 f417, f416, f414;
sub.f32 f418, f414, f416;
add.f32 f729, f744, f730;
mul.f32 f419, f730, 0f3F000000;
sub.f32 f420, f744, f419;
sub.f32 f421, f358, f374;
mul.f32 f422, f421, 0fBF5DB3D7;
sub.f32 f423, f420, f422;
add.f32 f424, f422, f420;
add.f32 f425, f391, f396;
add.f32 f426, f349, f425;
mul.f32 f429, f425, 0f3F000000;
sub.f32 f430, f349, f429;
add.f32 f728, f393, f398;
sub.f32 f431, f393, f398;
mul.f32 f432, f431, 0fBF5DB3D7;
add.f32 f433, f432, f430;
sub.f32 f434, f430, f432;
add.f32 f727, f355, f728;
mul.f32 f435, f728, 0f3F000000;
sub.f32 f436, f355, f435;
sub.f32 f437, f391, f396;
mul.f32 f438, f437, 0fBF5DB3D7;
sub.f32 f439, f436, f438;
add.f32 f440, f438, f436;
add.f32 f441, f401, f406;
add.f32 f442, f350, f441;
mul.f32 f445, f441, 0f3F000000;
sub.f32 f446, f350, f445;
add.f32 f726, f403, f408;
sub.f32 f447, f403, f408;
mul.f32 f448, f447, 0fBF5DB3D7;
add.f32 f449, f448, f446;
sub.f32 f450, f446, f448;
add.f32 f725, f356, f726;
mul.f32 f451, f726, 0f3F000000;
sub.f32 f452, f356, f451;
sub.f32 f453, f401, f406;
mul.f32 f454, f453, 0fBF5DB3D7;
sub.f32 f455, f452, f454;
add.f32 f456, f454, f452;
mul.f32 f723, f310, 0f3F791978;
mul.f32 f724, f751, 0f3E6C2691;
sub.f32 f459, f723, f724;
mul.f32 f460, f751, 0f3F791978;
fma.rn.f32 f461, f310, 0f3E6C2691, f460;
mul.f32 f721, f426, 0f3F64C51C;
mul.f32 f722, f727, 0f3EE5C902;
sub.f32 f464, f721, f722;
mul.f32 f465, f727, 0f3F64C51C;
fma.rn.f32 f466, f426, 0f3EE5C902, f465;
mul.f32 f468, f749, 0f3EE5C902;
mul.f32 f720, f326, 0f3F64C51C;
sub.f32 f469, f720, f468;
mul.f32 f470, f749, 0f3F64C51C;
fma.rn.f32 f471, f326, 0f3EE5C902, f470;
mul.f32 f473, f725, 0f3F4D57F2;
mul.f32 f719, f442, 0f3F18DF63;
sub.f32 f474, f719, f473;
mul.f32 f475, f725, 0f3F18DF63;
fma.rn.f32 f476, f442, 0f3F4D57F2, f475;
mul.f32 f478, f307, 0f3F248DBB;
mul.f32 f718, f301, 0f3F441B7D;
sub.f32 f479, f718, f478;
mul.f32 f480, f307, 0f3F441B7D;
fma.rn.f32 f481, f301, 0f3F248DBB, f480;
mul.f32 f483, f423, 0f3F7C1C5C;
mul.f32 f717, f417, 0f3E31D0D4;
sub.f32 f484, f717, f483;
mul.f32 f485, f423, 0f3E31D0D4;
fma.rn.f32 f486, f417, 0f3F7C1C5C, f485;
mul.f32 f488, f323, 0f3F4D57F2;
mul.f32 f716, f317, 0f3F18DF63;
sub.f32 f489, f716, f488;
mul.f32 f490, f323, 0f3F18DF63;
fma.rn.f32 f491, f317, 0f3F4D57F2, f490;
mul.f32 f493, f439, 0f3F753ECD;
mul.f32 f715, f433, 0fBE92D7E0;
sub.f32 f494, f715, f493;
mul.f32 f495, f439, 0fBE92D7E0;
fma.rn.f32 f496, f433, 0f3F753ECD, f495;
mul.f32 f713, f333, 0f3ECACAF8;
mul.f32 f714, f339, 0f3F6B1036;
sub.f32 f499, f713, f714;
mul.f32 f500, f339, 0f3ECACAF8;
fma.rn.f32 f501, f333, 0f3F6B1036, f500;
mul.f32 f711, f449, 0fBF2FAD88;
mul.f32 f712, f455, 0f3F3A3529;
sub.f32 f504, f711, f712;
mul.f32 f505, f455, 0fBF2FAD88;
fma.rn.f32 f506, f449, 0f3F3A3529, f505;
mul.f32 f709, f302, 0f3E31D0D4;
mul.f32 f710, f308, 0f3F7C1C5C;
sub.f32 f509, f709, f710;
mul.f32 f510, f308, 0f3E31D0D4;
fma.rn.f32 f511, f302, 0f3F7C1C5C, f510;
mul.f32 f707, f418, 0fBF708FB2;
mul.f32 f708, f424, 0f3EAF1D44;
sub.f32 f514, f707, f708;
mul.f32 f515, f424, 0fBF708FB2;
fma.rn.f32 f516, f418, 0f3EAF1D44, f515;
mul.f32 f518, f324, 0f3F7F9120;
mul.f32 f706, f318, 0fBD6E2946;
sub.f32 f519, f706, f518;
mul.f32 f520, f324, 0fBD6E2946;
fma.rn.f32 f521, f318, 0f3F7F9120, f520;
mul.f32 f523, f440, 0fBDEDC21F;
mul.f32 f705, f434, 0fBF7E44DE;
sub.f32 f524, f705, f523;
mul.f32 f525, f440, 0fBF7E44DE;
fma.rn.f32 f526, f434, 0fBDEDC21F, f525;
mul.f32 f528, f340, 0f3F753ECD;
mul.f32 f704, f334, 0fBE92D7E0;
sub.f32 f529, f704, f528;
mul.f32 f530, f340, 0fBE92D7E0;
fma.rn.f32 f531, f334, 0f3F753ECD, f530;
mul.f32 f533, f456, 0fBF0CAC9F;
mul.f32 f703, f450, 0fBF55E287;
sub.f32 f534, f703, f533;
mul.f32 f535, f456, 0fBF55E287;
fma.rn.f32 f536, f450, 0fBF0CAC9F, f535;
add.f32 f537, f294, f410;
mul.f32 f539, f537, 0f3F000000;
sub.f32 f540, f178, f539;
add.f32 f702, f753, f729;
sub.f32 f541, f753, f729;
mul.f32 f542, f541, 0fBF5DB3D7;
mul.f32 f543, f702, 0f3F000000;
sub.f32 f544, f778, f543;
sub.f32 f545, f294, f410;
mul.f32 f546, f545, 0fBF5DB3D7;
add.f32 f547, f459, f464;
mul.f32 f549, f547, 0f3F000000;
sub.f32 f550, f194, f549;
add.f32 f701, f461, f466;
sub.f32 f551, f461, f466;
mul.f32 f552, f551, 0fBF5DB3D7;
mul.f32 f553, f701, 0f3F000000;
sub.f32 f554, f776, f553;
sub.f32 f555, f459, f464;
mul.f32 f556, f555, 0fBF5DB3D7;
add.f32 f557, f469, f474;
mul.f32 f559, f557, 0f3F000000;
sub.f32 f560, f210, f559;
add.f32 f700, f471, f476;
sub.f32 f561, f471, f476;
mul.f32 f562, f561, 0fBF5DB3D7;
mul.f32 f563, f700, 0f3F000000;
sub.f32 f564, f774, f563;
sub.f32 f565, f469, f474;
mul.f32 f566, f565, 0fBF5DB3D7;
add.f32 f567, f479, f484;
mul.f32 f569, f567, 0f3F000000;
sub.f32 f570, f185, f569;
add.f32 f699, f481, f486;
sub.f32 f571, f481, f486;
mul.f32 f572, f571, 0fBF5DB3D7;
mul.f32 f573, f699, 0f3F000000;
sub.f32 f574, f191, f573;
sub.f32 f575, f479, f484;
mul.f32 f576, f575, 0fBF5DB3D7;
add.f32 f577, f489, f494;
mul.f32 f579, f577, 0f3F000000;
sub.f32 f580, f201, f579;
add.f32 f698, f491, f496;
sub.f32 f581, f491, f496;
mul.f32 f582, f581, 0fBF5DB3D7;
mul.f32 f583, f698, 0f3F000000;
sub.f32 f584, f207, f583;
sub.f32 f585, f489, f494;
mul.f32 f586, f585, 0fBF5DB3D7;
add.f32 f587, f499, f504;
mul.f32 f589, f587, 0f3F000000;
sub.f32 f590, f217, f589;
add.f32 f697, f501, f506;
sub.f32 f591, f501, f506;
mul.f32 f592, f591, 0fBF5DB3D7;
mul.f32 f593, f697, 0f3F000000;
sub.f32 f594, f223, f593;
sub.f32 f595, f499, f504;
mul.f32 f596, f595, 0fBF5DB3D7;
add.f32 f597, f509, f514;
mul.f32 f599, f597, 0f3F000000;
sub.f32 f600, f186, f599;
add.f32 f696, f511, f516;
sub.f32 f601, f511, f516;
mul.f32 f602, f601, 0fBF5DB3D7;
mul.f32 f603, f696, 0f3F000000;
sub.f32 f604, f192, f603;
sub.f32 f605, f509, f514;
mul.f32 f606, f605, 0fBF5DB3D7;
add.f32 f607, f519, f524;
mul.f32 f609, f607, 0f3F000000;
sub.f32 f610, f202, f609;
add.f32 f695, f521, f526;
sub.f32 f611, f521, f526;
mul.f32 f612, f611, 0fBF5DB3D7;
mul.f32 f613, f695, 0f3F000000;
sub.f32 f614, f208, f613;
sub.f32 f615, f519, f524;
mul.f32 f616, f615, 0fBF5DB3D7;
add.f32 f617, f529, f534;
mul.f32 f619, f617, 0f3F000000;
sub.f32 f620, f218, f619;
add.f32 f694, f531, f536;
sub.f32 f621, f531, f536;
mul.f32 f622, f621, 0fBF5DB3D7;
mul.f32 f623, f694, 0f3F000000;
sub.f32 f624, f224, f623;
sub.f32 f625, f529, f534;
mul.f32 f791, f700, 0f3F000000;
sub.f32 f790, f774, f791;
mul.f32 f626, f625, 0fBF5DB3D7;
add.f32 %1, f778, f702;
mul.f32 f793, f537, 0f3F000000;
sub.f32 f792, f178, f793;
add.f32 %0, f178, f537;
mul.f32 f795, f701, 0f3F000000;
sub.f32 f794, f776, f795;
add.f32 %3, f776, f701;
add.f32 %2, f194, f547;
add.f32 %5, f774, f700;
add.f32 %4, f210, f557;
add.f32 %7, f191, f699;
add.f32 %6, f185, f567;
add.f32 %9, f207, f698;
add.f32 %8, f201, f577;
add.f32 %11, f223, f697;
add.f32 %10, f217, f587;
add.f32 %13, f192, f696;
add.f32 %12, f186, f597;
add.f32 %15, f208, f695;
add.f32 %14, f202, f607;
add.f32 %17, f224, f694;
add.f32 %16, f218, f617;
add.f32 %18, f542, f792;
sub.f32 %19, f544, f546;
sub.f32 %21, f794, f556;
add.f32 %20, f552, f550;
sub.f32 %23, f790, f566;
add.f32 %22, f562, f560;
sub.f32 %25, f574, f576;
add.f32 %24, f572, f570;
add.f32 %26, f582, f580;
sub.f32 %27, f584, f586;
add.f32 %28, f592, f590;
sub.f32 %29, f594, f596;
add.f32 %30, f602, f600;
sub.f32 %31, f604, f606;
add.f32 %32, f612, f610;
sub.f32 %33, f614, f616;
sub.f32 %35, f624, f626;
add.f32 %34, f622, f620;
add.f32 %37, f546, f544;
sub.f32 %36, f792, f542;
add.f32 %39, f556, f794;
sub.f32 %38, f550, f552;
add.f32 %41, f566, f790;
sub.f32 %40, f560, f562;
add.f32 %43, f576, f574;
sub.f32 %42, f570, f572;
add.f32 %45, f586, f584;
sub.f32 %44, f580, f582;
add.f32 %47, f596, f594;
sub.f32 %46, f590, f592;
add.f32 %49, f606, f604;
sub.f32 %48, f600, f602;
add.f32 %51, f616, f614;
sub.f32 %50, f610, f612;
add.f32 %53, f626, f624;
sub.f32 %52, f620, f622;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y), "=f"(rmem[25].x), "=f"(rmem[25].y), "=f"(rmem[26].x), "=f"(rmem[26].y): "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y), "f"(rmem[25].x), "f"(rmem[25].y), "f"(rmem[26].x), "f"(rmem[26].y), "f"(rmem[19].y), "f"(rmem[10].y), "f"(rmem[1].y), "f"(rmem[13].y), "f"(rmem[22].y), "f"(rmem[4].y), "f"(rmem[25].y), "f"(rmem[16].y), "f"(rmem[7].y), "f"(rmem[20].y), "f"(rmem[11].y), "f"(rmem[2].y), "f"(rmem[23].y), "f"(rmem[14].y), "f"(rmem[5].y), "f"(rmem[17].y), "f"(rmem[8].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<325, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<316>;
.reg .b32 r<12>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %18;
mad.lo.s32 r3, r1, 216, r2;
add.f32 f37, %28, %36;
add.f32 f38, %20, f37;
add.f32 f39, %29, %37;
add.f32 f40, %21, f39;
mul.f32 f41, f37, 0f3F000000;
sub.f32 f42, %20, f41;
sub.f32 f43, %29, %37;
mul.f32 f44, f43, 0fBF5DB3D7;
add.f32 f45, f44, f42;
sub.f32 f46, f42, f44;
mul.f32 f47, f39, 0f3F000000;
sub.f32 f48, %21, f47;
sub.f32 f49, %28, %36;
mul.f32 f50, f49, 0fBF5DB3D7;
sub.f32 f51, f48, f50;
add.f32 f52, f50, f48;
add.f32 f53, %30, %38;
add.f32 f54, %22, f53;
add.f32 f55, %32, %40;
add.f32 f56, %24, f55;
mul.f32 f57, f53, 0f3F000000;
sub.f32 f58, %22, f57;
sub.f32 f59, %32, %40;
mul.f32 f60, f59, 0fBF5DB3D7;
add.f32 f61, f60, f58;
sub.f32 f62, f58, f60;
mul.f32 f63, f55, 0f3F000000;
sub.f32 f64, %24, f63;
sub.f32 f65, %30, %38;
mul.f32 f66, f65, 0fBF5DB3D7;
sub.f32 f67, f64, f66;
add.f32 f68, f66, f64;
add.f32 f69, %33, %41;
add.f32 f70, %25, f69;
add.f32 f71, %35, %42;
add.f32 f72, %27, f71;
mul.f32 f73, f69, 0f3F000000;
sub.f32 f74, %25, f73;
sub.f32 f75, %35, %42;
mul.f32 f76, f75, 0fBF5DB3D7;
add.f32 f77, f76, f74;
sub.f32 f78, f74, f76;
mul.f32 f79, f71, 0f3F000000;
sub.f32 f80, %27, f79;
sub.f32 f81, %33, %41;
mul.f32 f82, f81, 0fBF5DB3D7;
sub.f32 f83, f80, f82;
add.f32 f84, f82, f80;
mov.u32 r4, %tid.x;
mul.f32 f85, f61, 0f3F441B7D;
mul.f32 f86, f67, 0f3F248DBB;
sub.f32 f87, f85, f86;
mul.f32 f88, f67, 0f3F441B7D;
fma.rn.f32 f89, f61, 0f3F248DBB, f88;
mul.f32 f90, f77, 0f3E31D0D4;
mul.f32 f91, f83, 0f3F7C1C5C;
sub.f32 f92, f90, f91;
mul.f32 f93, f83, 0f3E31D0D4;
fma.rn.f32 f94, f77, 0f3F7C1C5C, f93;
mul.f32 f95, f62, 0f3E31D0D4;
mul.f32 f96, f68, 0f3F7C1C5C;
sub.f32 f97, f95, f96;
mul.f32 f98, f68, 0f3E31D0D4;
fma.rn.f32 f99, f62, 0f3F7C1C5C, f98;
mul.f32 f100, f78, 0fBF708FB2;
mul.f32 f101, f84, 0f3EAF1D44;
sub.f32 f102, f100, f101;
mul.f32 f103, f84, 0fBF708FB2;
fma.rn.f32 f104, f78, 0f3EAF1D44, f103;
add.f32 f105, f54, f70;
add.f32 f106, f56, f72;
mul.f32 f107, f105, 0f3F000000;
sub.f32 f108, f38, f107;
sub.f32 f109, f56, f72;
mul.f32 f110, f109, 0fBF5DB3D7;
add.f32 f111, f110, f108;
sub.f32 f112, f108, f110;
mul.f32 f113, f106, 0f3F000000;
sub.f32 f114, f40, f113;
sub.f32 f115, f54, f70;
mul.f32 f116, f115, 0fBF5DB3D7;
sub.f32 f117, f114, f116;
add.f32 f118, f116, f114;
add.f32 f119, f87, f92;
add.f32 f120, f45, f119;
add.f32 f121, f89, f94;
add.f32 f122, f51, f121;
mul.f32 f123, f119, 0f3F000000;
sub.f32 f124, f45, f123;
sub.f32 f125, f89, f94;
mul.f32 f126, f125, 0fBF5DB3D7;
add.f32 f127, f126, f124;
sub.f32 f128, f124, f126;
mul.f32 f129, f121, 0f3F000000;
sub.f32 f130, f51, f129;
sub.f32 f131, f87, f92;
mul.f32 f132, f131, 0fBF5DB3D7;
sub.f32 f133, f130, f132;
add.f32 f134, f132, f130;
add.f32 f135, f97, f102;
add.f32 f136, f46, f135;
add.f32 f137, f99, f104;
add.f32 f138, f52, f137;
mul.f32 f139, f135, 0f3F000000;
sub.f32 f140, f46, f139;
sub.f32 f141, f99, f104;
mul.f32 f142, f141, 0fBF5DB3D7;
add.f32 f143, f142, f140;
sub.f32 f144, f140, f142;
mul.f32 f145, f137, 0f3F000000;
sub.f32 f146, f52, f145;
sub.f32 f147, f97, f102;
mul.f32 f148, f147, 0fBF5DB3D7;
sub.f32 f149, f146, f148;
add.f32 f150, f148, f146;
mul.wide.u32 rd2, r4, -1431655765;
shr.u64 rd3, rd2, 33;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 3;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 216, r3;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %19;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f151, f152}, [rd6];
mul.f32 f155, f122, f152;
mul.f32 f156, f120, f152;
mul.f32 f157, f151, f122;
mul.f32 f158, f151, f151;
mul.f32 f159, f152, f152;
sub.f32 f160, f158, f159;
mul.f32 f161, f152, f151;
fma.rn.f32 f162, f152, f151, f161;
mul.f32 f163, f138, f162;
mul.f32 f164, f136, f162;
mul.f32 f165, f160, f138;
mul.f32 f166, f151, f160;
mul.f32 f167, f152, f162;
sub.f32 f168, f166, f167;
mul.f32 f169, f151, f162;
fma.rn.f32 f170, f152, f160, f169;
mul.f32 f171, f117, f170;
mul.f32 f172, f111, f170;
mul.f32 f173, f168, f117;
mul.f32 f174, f151, f168;
mul.f32 f175, f152, f170;
sub.f32 f176, f174, f175;
mul.f32 f177, f151, f170;
fma.rn.f32 f178, f152, f168, f177;
mul.f32 f179, f133, f178;
mul.f32 f180, f127, f178;
mul.f32 f181, f176, f133;
mul.f32 f182, f151, f176;
mul.f32 f183, f152, f178;
sub.f32 f184, f182, f183;
mul.f32 f185, f151, f178;
fma.rn.f32 f186, f152, f176, f185;
mul.f32 f187, f149, f186;
mul.f32 f188, f143, f186;
mul.f32 f189, f184, f149;
mul.f32 f190, f151, f184;
mul.f32 f191, f152, f186;
sub.f32 f192, f190, f191;
mul.f32 f193, f151, f186;
fma.rn.f32 f194, f152, f184, f193;
mul.f32 f195, f118, f194;
mul.f32 f196, f112, f194;
mul.f32 f197, f192, f118;
mul.f32 f198, f151, f192;
mul.f32 f199, f152, f194;
sub.f32 f200, f198, f199;
mul.f32 f201, f151, f194;
fma.rn.f32 f202, f152, f192, f201;
mul.f32 f203, f134, f202;
mul.f32 f204, f128, f202;
mul.f32 f205, f200, f134;
mul.f32 f206, f151, f200;
mul.f32 f207, f152, f202;
sub.f32 f208, f206, f207;
mul.f32 f209, f151, f202;
fma.rn.f32 f210, f152, f200, f209;
mul.f32 f211, f150, f210;
mul.f32 f212, f144, f210;
mul.f32 f213, f208, f150;
barrier.sync 0;
mad.lo.s32 r9, r7, 72, r8;
add.f32 f214, f40, f106;
add.f32 f215, f38, f105;
st.shared.v2.f32 [r9], {f215, f214};
fma.rn.f32 f216, f151, f120, f155;
sub.f32 f217, f157, f156;
st.shared.v2.f32 [r9+8], {f216, f217};
fma.rn.f32 f218, f160, f136, f163;
sub.f32 f219, f165, f164;
st.shared.v2.f32 [r9+16], {f218, f219};
sub.f32 f220, f173, f172;
fma.rn.f32 f221, f168, f111, f171;
st.shared.v2.f32 [r9+24], {f221, f220};
fma.rn.f32 f222, f176, f127, f179;
sub.f32 f223, f181, f180;
st.shared.v2.f32 [r9+32], {f222, f223};
sub.f32 f224, f189, f188;
fma.rn.f32 f225, f184, f143, f187;
st.shared.v2.f32 [r9+40], {f225, f224};
fma.rn.f32 f226, f192, f112, f195;
sub.f32 f227, f197, f196;
st.shared.v2.f32 [r9+48], {f226, f227};
fma.rn.f32 f228, f200, f128, f203;
sub.f32 f229, f205, f204;
st.shared.v2.f32 [r9+56], {f228, f229};
fma.rn.f32 f230, f208, f144, f211;
sub.f32 f231, f213, f212;
st.shared.v2.f32 [r9+64], {f230, f231};
barrier.sync 0;
shl.b32 r10, r7, 6;
sub.s32 r11, r9, r10;
ld.shared.v2.f32 {f232, f233}, [r11];
ld.shared.v2.f32 {f236, f237}, [r11+24];
ld.shared.v2.f32 {f240, f241}, [r11+48];
ld.shared.v2.f32 {f244, f245}, [r11+72];
ld.shared.v2.f32 {f248, f249}, [r11+96];
ld.shared.v2.f32 {f252, f253}, [r11+120];
ld.shared.v2.f32 {f256, f257}, [r11+144];
ld.shared.v2.f32 {f260, f261}, [r11+168];
ld.shared.v2.f32 {f264, f265}, [r11+192];
add.f32 f268, f244, f256;
add.f32 f269, f245, f257;
mul.f32 f270, f268, 0f3F000000;
sub.f32 f271, f232, f270;
sub.f32 f272, f245, f257;
mul.f32 f273, f272, 0fBF5DB3D7;
mul.f32 f274, f269, 0f3F000000;
sub.f32 f275, f233, f274;
sub.f32 f276, f244, f256;
mul.f32 f277, f276, 0fBF5DB3D7;
add.f32 f278, f248, f260;
add.f32 f279, f249, f261;
mul.f32 f280, f278, 0f3F000000;
sub.f32 f281, f236, f280;
sub.f32 f282, f249, f261;
mul.f32 f283, f282, 0fBF5DB3D7;
mul.f32 f284, f279, 0f3F000000;
sub.f32 f285, f237, f284;
sub.f32 f286, f248, f260;
mul.f32 f287, f286, 0fBF5DB3D7;
add.f32 f288, f252, f264;
add.f32 f289, f253, f265;
mul.f32 f290, f288, 0f3F000000;
sub.f32 f291, f240, f290;
sub.f32 f292, f253, f265;
mul.f32 f293, f292, 0fBF5DB3D7;
mul.f32 f294, f289, 0f3F000000;
sub.f32 f295, f241, f294;
sub.f32 f296, f252, f264;
mul.f32 f297, f296, 0fBF5DB3D7;
add.f32 %1, f233, f269;
add.f32 %0, f232, f268;
add.f32 %3, f237, f279;
add.f32 %2, f236, f278;
add.f32 %5, f241, f289;
add.f32 %4, f240, f288;
sub.f32 %7, f275, f277;
add.f32 %6, f273, f271;
sub.f32 %9, f285, f287;
add.f32 %8, f283, f281;
sub.f32 %11, f295, f297;
add.f32 %10, f293, f291;
add.f32 %13, f277, f275;
sub.f32 %12, f271, f273;
add.f32 %15, f287, f285;
sub.f32 %14, f281, f283;
add.f32 %17, f297, f295;
sub.f32 %16, f291, f293;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y): "r"(smem), "l"(lut_sp_9_27), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<324, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<298>;
.reg .b32 r<12>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %18;
mad.lo.s32 r3, r1, 108, r2;
add.f32 f37, %28, %36;
add.f32 f38, %20, f37;
add.f32 f39, %29, %37;
add.f32 f40, %21, f39;
mul.f32 f41, f37, 0f3F000000;
sub.f32 f42, %20, f41;
sub.f32 f43, %29, %37;
mul.f32 f44, f43, 0fBF5DB3D7;
add.f32 f45, f44, f42;
sub.f32 f46, f42, f44;
mul.f32 f47, f39, 0f3F000000;
sub.f32 f48, %21, f47;
sub.f32 f49, %28, %36;
mul.f32 f50, f49, 0fBF5DB3D7;
sub.f32 f51, f48, f50;
add.f32 f52, f50, f48;
add.f32 f53, %30, %38;
add.f32 f54, %22, f53;
add.f32 f55, %32, %40;
add.f32 f56, %24, f55;
mul.f32 f57, f53, 0f3F000000;
sub.f32 f58, %22, f57;
sub.f32 f59, %32, %40;
mul.f32 f60, f59, 0fBF5DB3D7;
add.f32 f61, f60, f58;
sub.f32 f62, f58, f60;
mul.f32 f63, f55, 0f3F000000;
sub.f32 f64, %24, f63;
sub.f32 f65, %30, %38;
mul.f32 f66, f65, 0fBF5DB3D7;
sub.f32 f67, f64, f66;
add.f32 f68, f66, f64;
add.f32 f69, %33, %41;
add.f32 f70, %25, f69;
add.f32 f71, %35, %42;
add.f32 f72, %27, f71;
mul.f32 f73, f69, 0f3F000000;
sub.f32 f74, %25, f73;
sub.f32 f75, %35, %42;
mul.f32 f76, f75, 0fBF5DB3D7;
add.f32 f77, f76, f74;
sub.f32 f78, f74, f76;
mul.f32 f79, f71, 0f3F000000;
sub.f32 f80, %27, f79;
sub.f32 f81, %33, %41;
mul.f32 f82, f81, 0fBF5DB3D7;
sub.f32 f83, f80, f82;
add.f32 f84, f82, f80;
mov.u32 r4, %tid.x;
mul.f32 f85, f61, 0f3F441B7D;
mul.f32 f86, f67, 0f3F248DBB;
sub.f32 f87, f85, f86;
mul.f32 f88, f67, 0f3F441B7D;
fma.rn.f32 f89, f61, 0f3F248DBB, f88;
mul.f32 f90, f77, 0f3E31D0D4;
mul.f32 f91, f83, 0f3F7C1C5C;
sub.f32 f92, f90, f91;
mul.f32 f93, f83, 0f3E31D0D4;
fma.rn.f32 f94, f77, 0f3F7C1C5C, f93;
mul.f32 f95, f62, 0f3E31D0D4;
mul.f32 f96, f68, 0f3F7C1C5C;
sub.f32 f97, f95, f96;
mul.f32 f98, f68, 0f3E31D0D4;
fma.rn.f32 f99, f62, 0f3F7C1C5C, f98;
mul.f32 f100, f78, 0fBF708FB2;
mul.f32 f101, f84, 0f3EAF1D44;
sub.f32 f102, f100, f101;
mul.f32 f103, f84, 0fBF708FB2;
fma.rn.f32 f104, f78, 0f3EAF1D44, f103;
add.f32 f105, f54, f70;
add.f32 f106, f38, f105;
add.f32 f107, f56, f72;
add.f32 f108, f40, f107;
mul.f32 f109, f105, 0f3F000000;
sub.f32 f110, f38, f109;
sub.f32 f111, f56, f72;
mul.f32 f112, f111, 0fBF5DB3D7;
add.f32 f113, f112, f110;
sub.f32 f114, f110, f112;
mul.f32 f115, f107, 0f3F000000;
sub.f32 f116, f40, f115;
sub.f32 f117, f54, f70;
mul.f32 f118, f117, 0fBF5DB3D7;
sub.f32 f119, f116, f118;
add.f32 f120, f118, f116;
add.f32 f121, f87, f92;
add.f32 f122, f45, f121;
add.f32 f123, f89, f94;
add.f32 f124, f51, f123;
mul.f32 f125, f121, 0f3F000000;
sub.f32 f126, f45, f125;
sub.f32 f127, f89, f94;
mul.f32 f128, f127, 0fBF5DB3D7;
add.f32 f129, f128, f126;
sub.f32 f130, f126, f128;
mul.f32 f131, f123, 0f3F000000;
sub.f32 f132, f51, f131;
sub.f32 f133, f87, f92;
mul.f32 f134, f133, 0fBF5DB3D7;
sub.f32 f135, f132, f134;
add.f32 f136, f134, f132;
add.f32 f137, f97, f102;
add.f32 f138, f46, f137;
add.f32 f139, f99, f104;
add.f32 f140, f52, f139;
mul.f32 f141, f137, 0f3F000000;
sub.f32 f142, f46, f141;
sub.f32 f143, f99, f104;
mul.f32 f144, f143, 0fBF5DB3D7;
add.f32 f145, f144, f142;
sub.f32 f146, f142, f144;
mul.f32 f147, f139, 0f3F000000;
sub.f32 f148, f52, f147;
sub.f32 f149, f97, f102;
mul.f32 f150, f149, 0fBF5DB3D7;
sub.f32 f151, f148, f150;
add.f32 f152, f150, f148;
mul.wide.u32 rd2, r4, -1431655765;
shr.u64 rd3, rd2, 33;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 3;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %19;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f153, f154}, [rd6];
mul.f32 f157, f124, f154;
fma.rn.f32 f158, f153, f122, f157;
mul.f32 f159, f122, f154;
mul.f32 f160, f153, f124;
sub.f32 f161, f160, f159;
mul.f32 f162, f153, f153;
mul.f32 f163, f154, f154;
sub.f32 f164, f162, f163;
mul.f32 f165, f154, f153;
fma.rn.f32 f166, f154, f153, f165;
mul.f32 f167, f140, f166;
fma.rn.f32 f168, f164, f138, f167;
mul.f32 f169, f138, f166;
mul.f32 f170, f164, f140;
sub.f32 f171, f170, f169;
mul.f32 f172, f153, f164;
mul.f32 f173, f154, f166;
sub.f32 f174, f172, f173;
mul.f32 f175, f153, f166;
fma.rn.f32 f176, f154, f164, f175;
mul.f32 f177, f119, f176;
fma.rn.f32 f178, f174, f113, f177;
mul.f32 f179, f113, f176;
mul.f32 f180, f174, f119;
sub.f32 f181, f180, f179;
mul.f32 f182, f153, f174;
mul.f32 f183, f154, f176;
sub.f32 f184, f182, f183;
mul.f32 f185, f153, f176;
fma.rn.f32 f186, f154, f174, f185;
mul.f32 f187, f135, f186;
fma.rn.f32 f188, f184, f129, f187;
mul.f32 f189, f129, f186;
mul.f32 f190, f184, f135;
sub.f32 f191, f190, f189;
mul.f32 f192, f153, f184;
mul.f32 f193, f154, f186;
sub.f32 f194, f192, f193;
mul.f32 f195, f153, f186;
fma.rn.f32 f196, f154, f184, f195;
mul.f32 f197, f151, f196;
fma.rn.f32 f198, f194, f145, f197;
mul.f32 f199, f145, f196;
mul.f32 f200, f194, f151;
sub.f32 f201, f200, f199;
mul.f32 f202, f153, f194;
mul.f32 f203, f154, f196;
sub.f32 f204, f202, f203;
mul.f32 f205, f153, f196;
fma.rn.f32 f206, f154, f194, f205;
mul.f32 f207, f120, f206;
fma.rn.f32 f208, f204, f114, f207;
mul.f32 f209, f114, f206;
mul.f32 f210, f204, f120;
sub.f32 f211, f210, f209;
mul.f32 f212, f153, f204;
mul.f32 f213, f154, f206;
sub.f32 f214, f212, f213;
mul.f32 f215, f153, f206;
fma.rn.f32 f216, f154, f204, f215;
mul.f32 f217, f136, f216;
fma.rn.f32 f218, f214, f130, f217;
mul.f32 f219, f130, f216;
mul.f32 f220, f214, f136;
sub.f32 f221, f220, f219;
mul.f32 f222, f153, f214;
mul.f32 f223, f154, f216;
sub.f32 f224, f222, f223;
mul.f32 f225, f153, f216;
fma.rn.f32 f226, f154, f214, f225;
mul.f32 f227, f152, f226;
fma.rn.f32 f228, f224, f146, f227;
mul.f32 f229, f146, f226;
mul.f32 f230, f224, f152;
sub.f32 f231, f230, f229;
mad.lo.s32 r8, r5, 108, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 36, r8;
st.shared.f32 [r9], f106;
st.shared.f32 [r9+4], f158;
st.shared.f32 [r9+8], f168;
st.shared.f32 [r9+12], f178;
st.shared.f32 [r9+16], f188;
st.shared.f32 [r9+20], f198;
st.shared.f32 [r9+24], f208;
st.shared.f32 [r9+28], f218;
st.shared.f32 [r9+32], f228;
barrier.sync 0;
shl.b32 r10, r7, 5;
sub.s32 r11, r9, r10;
ld.shared.f32 f232, [r11];
ld.shared.f32 f233, [r11+12];
ld.shared.f32 f234, [r11+24];
ld.shared.f32 f235, [r11+36];
ld.shared.f32 f236, [r11+48];
ld.shared.f32 f237, [r11+60];
ld.shared.f32 f238, [r11+72];
ld.shared.f32 f239, [r11+84];
ld.shared.f32 f240, [r11+96];
barrier.sync 0;
st.shared.f32 [r9], f108;
st.shared.f32 [r9+4], f161;
st.shared.f32 [r9+8], f171;
st.shared.f32 [r9+12], f181;
st.shared.f32 [r9+16], f191;
st.shared.f32 [r9+20], f201;
st.shared.f32 [r9+24], f211;
st.shared.f32 [r9+28], f221;
st.shared.f32 [r9+32], f231;
barrier.sync 0;
ld.shared.f32 f241, [r11];
ld.shared.f32 f242, [r11+12];
ld.shared.f32 f243, [r11+24];
ld.shared.f32 f244, [r11+36];
ld.shared.f32 f245, [r11+48];
ld.shared.f32 f246, [r11+60];
ld.shared.f32 f247, [r11+72];
ld.shared.f32 f248, [r11+84];
ld.shared.f32 f249, [r11+96];
add.f32 f250, f235, f238;
add.f32 f251, f244, f247;
mul.f32 f252, f250, 0f3F000000;
sub.f32 f253, f232, f252;
sub.f32 f254, f244, f247;
mul.f32 f255, f254, 0fBF5DB3D7;
mul.f32 f256, f251, 0f3F000000;
sub.f32 f257, f241, f256;
sub.f32 f258, f235, f238;
mul.f32 f259, f258, 0fBF5DB3D7;
add.f32 f260, f236, f239;
add.f32 f261, f245, f248;
mul.f32 f262, f260, 0f3F000000;
sub.f32 f263, f233, f262;
sub.f32 f264, f245, f248;
mul.f32 f265, f264, 0fBF5DB3D7;
mul.f32 f266, f261, 0f3F000000;
sub.f32 f267, f242, f266;
sub.f32 f268, f236, f239;
mul.f32 f269, f268, 0fBF5DB3D7;
add.f32 f270, f237, f240;
add.f32 f271, f246, f249;
mul.f32 f272, f270, 0f3F000000;
sub.f32 f273, f234, f272;
sub.f32 f274, f246, f249;
mul.f32 f275, f274, 0fBF5DB3D7;
mul.f32 f276, f271, 0f3F000000;
sub.f32 f277, f243, f276;
sub.f32 f278, f237, f240;
mul.f32 f279, f278, 0fBF5DB3D7;
add.f32 %0, f232, f250;
add.f32 %1, f241, f251;
add.f32 %2, f233, f260;
add.f32 %3, f242, f261;
add.f32 %4, f234, f270;
add.f32 %5, f243, f271;
add.f32 %6, f255, f253;
sub.f32 %7, f257, f259;
add.f32 %8, f265, f263;
sub.f32 %9, f267, f269;
add.f32 %10, f275, f273;
sub.f32 %11, f277, f279;
sub.f32 %12, f253, f255;
add.f32 %13, f259, f257;
sub.f32 %14, f263, f265;
add.f32 %15, f269, f267;
sub.f32 %16, f273, f275;
add.f32 %17, f279, f277;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y): "r"(smem), "l"(lut_sp_9_27), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<326, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<123>;
.reg .b32 r<18>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %6;
mad.lo.s32 r3, r1, 216, r2;
mov.u32 r4, %tid.x;
add.f32 f13, %11, %14;
add.f32 f14, %13, %15;
mul.f32 f15, f13, 0f3F000000;
sub.f32 f16, %9, f15;
sub.f32 f17, %13, %15;
mul.f32 f18, f17, 0fBF5DB3D7;
add.f32 f19, f18, f16;
sub.f32 f20, f16, f18;
mul.f32 f21, f14, 0f3F000000;
sub.f32 f22, %10, f21;
sub.f32 f23, %11, %14;
mul.f32 f24, f23, 0fBF5DB3D7;
sub.f32 f25, f22, f24;
add.f32 f26, f24, f22;
mul.wide.u32 rd2, r4, 954437177;
shr.u64 rd3, rd2, 33;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 9;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 216, r3;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %7;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f27, f28}, [rd6];
mul.f32 f31, f25, f28;
mul.f32 f32, f19, f28;
mul.f32 f33, f27, f25;
mul.f32 f34, f27, f27;
mul.f32 f35, f28, f28;
sub.f32 f36, f34, f35;
mul.f32 f37, f28, f27;
fma.rn.f32 f38, f28, f27, f37;
mul.f32 f39, f26, f38;
mul.f32 f40, f20, f38;
mul.f32 f41, f36, f26;
barrier.sync 0;
mad.lo.s32 r9, r7, 24, r8;
add.f32 f42, %10, f14;
add.f32 f43, %9, f13;
st.shared.v2.f32 [r9], {f43, f42};
fma.rn.f32 f44, f27, f19, f31;
sub.f32 f45, f33, f32;
st.shared.v2.f32 [r9+8], {f44, f45};
sub.f32 f46, f41, f40;
fma.rn.f32 f47, f36, f20, f39;
st.shared.v2.f32 [r9+16], {f47, f46};
barrier.sync 0;
shl.b32 r10, r7, 4;
sub.s32 r11, r9, r10;
ld.shared.v2.f32 {f48, f49}, [r11];
ld.shared.v2.f32 {f52, f53}, [r11+72];
ld.shared.v2.f32 {f56, f57}, [r11+144];
add.f32 f60, f52, f56;
add.f32 f61, f53, f57;
mul.f32 f62, f60, 0f3F000000;
sub.f32 f63, f48, f62;
sub.f32 f64, f53, f57;
mul.f32 f65, f64, 0fBF5DB3D7;
add.f32 f66, f65, f63;
sub.f32 f67, f63, f65;
mul.f32 f68, f61, 0f3F000000;
sub.f32 f69, f49, f68;
sub.f32 f70, f52, f56;
mul.f32 f71, f70, 0fBF5DB3D7;
sub.f32 f72, f69, f71;
add.f32 f73, f71, f69;
mul.wide.u32 rd7, r7, -1431655765;
shr.u64 rd8, rd7, 33;
cvt.u32.u64 r12, rd8;
mul.lo.s32 r13, r12, 3;
sub.s32 r14, r7, r13;
shl.b32 r15, r14, 3;
add.s32 r16, r8, r15;
mul.wide.u32 rd9, r12, 8;
mov.u64 rd10, %8;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f74, f75}, [rd11];
mul.f32 f78, f72, f75;
mul.f32 f79, f66, f75;
mul.f32 f80, f74, f72;
mul.f32 f81, f74, f74;
mul.f32 f82, f75, f75;
sub.f32 f83, f81, f82;
mul.f32 f84, f75, f74;
fma.rn.f32 f85, f75, f74, f84;
mul.f32 f86, f73, f85;
mul.f32 f87, f67, f85;
mul.f32 f88, f83, f73;
barrier.sync 0;
mad.lo.s32 r17, r12, 72, r16;
add.f32 f89, f49, f61;
add.f32 f90, f48, f60;
st.shared.v2.f32 [r17], {f90, f89};
fma.rn.f32 f91, f74, f66, f78;
sub.f32 f92, f80, f79;
st.shared.v2.f32 [r17+24], {f91, f92};
fma.rn.f32 f93, f83, f67, f86;
sub.f32 f94, f88, f87;
st.shared.v2.f32 [r17+48], {f93, f94};
barrier.sync 0;
ld.shared.v2.f32 {f95, f96}, [r11];
ld.shared.v2.f32 {f99, f100}, [r11+72];
ld.shared.v2.f32 {f103, f104}, [r11+144];
add.f32 f107, f99, f103;
add.f32 f108, f100, f104;
mul.f32 f109, f107, 0f3F000000;
sub.f32 f110, f95, f109;
sub.f32 f111, f100, f104;
mul.f32 f112, f111, 0fBF5DB3D7;
mul.f32 f113, f108, 0f3F000000;
sub.f32 f114, f96, f113;
sub.f32 f115, f99, f103;
mul.f32 f116, f115, 0fBF5DB3D7;
add.f32 %1, f96, f108;
add.f32 %0, f95, f107;
sub.f32 %3, f114, f116;
add.f32 %2, f112, f110;
add.f32 %5, f116, f114;
sub.f32 %4, f110, f112;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y): "r"(smem), "l"(lut_sp_3_27), "l"(lut_sp_3_9), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<327, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<111>;
.reg .b32 r<18>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %6;
mad.lo.s32 r3, r1, 108, r2;
mov.u32 r4, %tid.x;
add.f32 f13, %11, %14;
add.f32 f14, %9, f13;
add.f32 f15, %13, %15;
add.f32 f16, %10, f15;
mul.f32 f17, f13, 0f3F000000;
sub.f32 f18, %9, f17;
sub.f32 f19, %13, %15;
mul.f32 f20, f19, 0fBF5DB3D7;
add.f32 f21, f20, f18;
sub.f32 f22, f18, f20;
mul.f32 f23, f15, 0f3F000000;
sub.f32 f24, %10, f23;
sub.f32 f25, %11, %14;
mul.f32 f26, f25, 0fBF5DB3D7;
sub.f32 f27, f24, f26;
add.f32 f28, f26, f24;
mul.wide.u32 rd2, r4, 954437177;
shr.u64 rd3, rd2, 33;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 9;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 108, r3;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %7;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f29, f30}, [rd6];
mul.f32 f33, f27, f30;
fma.rn.f32 f34, f29, f21, f33;
mul.f32 f35, f21, f30;
mul.f32 f36, f29, f27;
sub.f32 f37, f36, f35;
mul.f32 f38, f29, f29;
mul.f32 f39, f30, f30;
sub.f32 f40, f38, f39;
mul.f32 f41, f30, f29;
fma.rn.f32 f42, f30, f29, f41;
mul.f32 f43, f28, f42;
fma.rn.f32 f44, f40, f22, f43;
mul.f32 f45, f22, f42;
mul.f32 f46, f40, f28;
sub.f32 f47, f46, f45;
barrier.sync 0;
mad.lo.s32 r9, r7, 12, r8;
st.shared.f32 [r9], f14;
st.shared.f32 [r9+4], f34;
st.shared.f32 [r9+8], f44;
barrier.sync 0;
shl.b32 r10, r7, 3;
sub.s32 r11, r9, r10;
ld.shared.f32 f48, [r11];
ld.shared.f32 f49, [r11+36];
ld.shared.f32 f50, [r11+72];
barrier.sync 0;
st.shared.f32 [r9], f16;
st.shared.f32 [r9+4], f37;
st.shared.f32 [r9+8], f47;
barrier.sync 0;
ld.shared.f32 f51, [r11];
ld.shared.f32 f52, [r11+36];
ld.shared.f32 f53, [r11+72];
add.f32 f54, f49, f50;
add.f32 f55, f48, f54;
add.f32 f56, f52, f53;
add.f32 f57, f51, f56;
mul.f32 f58, f54, 0f3F000000;
sub.f32 f59, f48, f58;
sub.f32 f60, f52, f53;
mul.f32 f61, f60, 0fBF5DB3D7;
add.f32 f62, f61, f59;
sub.f32 f63, f59, f61;
mul.f32 f64, f56, 0f3F000000;
sub.f32 f65, f51, f64;
sub.f32 f66, f49, f50;
mul.f32 f67, f66, 0fBF5DB3D7;
sub.f32 f68, f65, f67;
add.f32 f69, f67, f65;
mul.wide.u32 rd7, r7, -1431655765;
shr.u64 rd8, rd7, 33;
cvt.u32.u64 r12, rd8;
mul.lo.s32 r13, r12, 3;
sub.s32 r14, r7, r13;
shl.b32 r15, r14, 2;
add.s32 r16, r8, r15;
mul.wide.u32 rd9, r12, 8;
mov.u64 rd10, %8;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f70, f71}, [rd11];
mul.f32 f74, f68, f71;
fma.rn.f32 f75, f70, f62, f74;
mul.f32 f76, f62, f71;
mul.f32 f77, f70, f68;
sub.f32 f78, f77, f76;
mul.f32 f79, f70, f70;
mul.f32 f80, f71, f71;
sub.f32 f81, f79, f80;
mul.f32 f82, f71, f70;
fma.rn.f32 f83, f71, f70, f82;
mul.f32 f84, f69, f83;
fma.rn.f32 f85, f81, f63, f84;
mul.f32 f86, f63, f83;
mul.f32 f87, f81, f69;
sub.f32 f88, f87, f86;
barrier.sync 0;
mad.lo.s32 r17, r12, 36, r16;
st.shared.f32 [r17], f55;
st.shared.f32 [r17+12], f75;
st.shared.f32 [r17+24], f85;
barrier.sync 0;
ld.shared.f32 f89, [r11];
ld.shared.f32 f90, [r11+36];
ld.shared.f32 f91, [r11+72];
barrier.sync 0;
st.shared.f32 [r17], f57;
st.shared.f32 [r17+12], f78;
st.shared.f32 [r17+24], f88;
barrier.sync 0;
ld.shared.f32 f92, [r11];
ld.shared.f32 f93, [r11+36];
ld.shared.f32 f94, [r11+72];
add.f32 f95, f90, f91;
add.f32 f96, f93, f94;
mul.f32 f97, f95, 0f3F000000;
sub.f32 f98, f89, f97;
sub.f32 f99, f93, f94;
mul.f32 f100, f99, 0fBF5DB3D7;
mul.f32 f101, f96, 0f3F000000;
sub.f32 f102, f92, f101;
sub.f32 f103, f90, f91;
mul.f32 f104, f103, 0fBF5DB3D7;
add.f32 %0, f89, f95;
add.f32 %1, f92, f96;
add.f32 %2, f100, f98;
sub.f32 %3, f102, f104;
sub.f32 %4, f98, f100;
add.f32 %5, f104, f102;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y): "r"(smem), "l"(lut_sp_3_27), "l"(lut_sp_3_9), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y));
};


#endif
